//********************************************************************;
//*                                                                  *;
//*  Intel(R) Confidential                                           *;
//*                                                                  *;
//*  TXTINFO64   Tool                                                *;
//*                                                                  *;
//*  Copyright (c) 2009 Intel Corp.                                  *;
//*                                                                  *;
//*  This code has been developed by Intel Corporation.              *;
//*  Licensee has Intel's permission to incorporate this source code *;
//*  into their product, royalty free.  This source code may NOT be  *;
//*  redistributed to anyone without Intel's written permission.     *;
//*                                                                  *;
//*  Intel specifically disclaims all warranties, express or         *;
//*  implied, and all liability, including consequential and other   *;
//*  indirect damages, for the use of this code, including liability *;
//*  for infringement of any proprietary rights, and including the   *;
//*  warranties of merchantability and fitness for a particular      *;
//*  purpose.  Intel does not assume any responsibility for any      *;
//*  errors which may appear in this code nor any responsibility to  *;
//*  update it.                                                      *;
//*                                                                  *;
//********************************************************************;

#include "Uefi.h"
#include "Uefilib.h"
#include "MemoryAllocationLib.h" //For AllocateZeroPool
#include "Base.h" //For OFFSET_OF Macro
#include "BaseMemoryLib.h"
#include "TpmTIS.h"
//#include "TpmTIS.h"
//#include "TPM.h"
#include "WaitAndStatusCheck.h"
#include "OutputFormat.h"
#include "Debug.h"

extern EFI_SYSTEM_TABLE   *gST;


/*Description: Read current information regarding the TPM*/
UINT8 ExecuteTPMCmdSGL(IN UINT32 NumInputBuffers, IN TIS_BUFFER_INFO *InputBuffers, IN UINT32  NumOutputBuffers, IN OUT  TIS_BUFFER_INFO *OutputBuffers )
{
	UINT8 u8CmdStatus = TCG_OK;
	UINT8 *u8CommandInputBuffer = NULL;
	UINT8 *pu8CommandInputBuffer = NULL;
	UINT8 *u8CommandOutputBuffer = NULL;
	UINT8 *pu8CommandOutputBuffer = NULL;	
	UINT8 simulatorCommandHeader[9];
	UINT32 commandBufferSize = 0;
	UINT32 i;
	UINT32 j = 3;
	UINT32 inputBufferSize = 0;
	UINT32 outputBufferSize = 0;

	union {
		UINT32	int_data;
		UINT8	byte_buff[4];
	} tmp;

	
	//calculate total size of input and output buffers
	for (i = 0; i < NumInputBuffers; i++) {
		inputBufferSize += InputBuffers[i].Size;
	}

	//save the command buffer size
	commandBufferSize = inputBufferSize;

	//add 9 bytes for the simulator command header
	inputBufferSize += 9;

	for (i = 0; i < NumOutputBuffers; i++) {
		outputBufferSize += OutputBuffers[i].Size;
	}
	
	//allocate input and output buffer
	u8CommandInputBuffer = (UINT8 *)/*malloc*/AllocateZeroPool(inputBufferSize);
	pu8CommandInputBuffer = u8CommandInputBuffer;
	
	u8CommandOutputBuffer = (UINT8 *)/*malloc*/AllocateZeroPool(outputBufferSize);
	pu8CommandOutputBuffer = u8CommandOutputBuffer;
	
	// this is the code for indicating a tpm command to the simulator
	simulatorCommandHeader[0] = 0x00;
	simulatorCommandHeader[1] = 0x00;
	simulatorCommandHeader[2] = 0x00;
	simulatorCommandHeader[3] = 0x08;
	//simulatorCommandHeader[4] = 0x03; //locality
	simulatorCommandHeader[4] = TPMLocality;
	
	// convert the command size integer into 4 bytes, reorder the byes to be little endian
	tmp.int_data = commandBufferSize;
	
	for (i = 0; i < 4; i++) {
		simulatorCommandHeader[i+5] = tmp.byte_buff[j];
		j--;
	}	
	//copy the simulator command header into the input buffer
	CopyMem(pu8CommandInputBuffer, simulatorCommandHeader, 9);

	//Copy contents of array of input buffers into the single tpm input buffer
	for (i = 0; i < NumInputBuffers; i++) {
		CopyMem( pu8CommandInputBuffer + 9, InputBuffers[i].Buffer, InputBuffers[i].Size );
		pu8CommandInputBuffer += InputBuffers[i].Size;
	}
		
	//transmit the input buffer and recieve the response int he output buffer
	//u8CmdStatus = ExecuteTPMCmd(u8CommandInputBuffer, inputBufferSize, u8CommandOutputBuffer, outputBufferSize);
	
	u8CmdStatus = TieSendRecvTPMCommand((const char*)u8CommandInputBuffer, inputBufferSize, (char*)u8CommandOutputBuffer, &outputBufferSize);
	
	if(TCG_OK == u8CmdStatus){
		
		//Copy the structures in the single output buffer into the array of outoput buffers
		for (i = 0; i < NumOutputBuffers; i++) {
			CopyMem(OutputBuffers[i].Buffer, pu8CommandOutputBuffer, OutputBuffers[i].Size);
			pu8CommandOutputBuffer += OutputBuffers[i].Size;
		}
		//FreePool(u8CommandInputBuffer);
		//FreePool(u8CommandOutputBuffer);
	}
	else{
		errColor;
		DEBUG_LOG((L"ERROR : ExecuteTPMCmdSGL(), error in communicating with the TPM\n"));
		norColor;
	}

	return u8CmdStatus;
}


UINT32 TieSocketConfigure()
{
	UINT32 Status = 0;
	WSADATA WsaDat;
	SOCKADDR_IN SockAddrPlatform;
	SOCKADDR_IN SockAddrTPM;

	if(WSAStartup(MAKEWORD(2,2),&WsaDat)!=0)
	{
		printf("Winsock error - Winsock initialization failed\n");
		WSACleanup();
		//system("PAUSE");
		return -1;
	}

	SocketPlatform = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	if(SocketPlatform==INVALID_SOCKET)
	{
		printf("Winsock error - Socket creation Failed!\r\n");
		WSACleanup();
		//system("PAUSE");
		return -1;
	}
	
	host=gethostbyname("localhost"); 
	if((host=gethostbyname("localhost"))==NULL)
	{
		printf("Failed to resolve hostname.\n");
		WSACleanup();
		//system("PAUSE");
		return -1;
	}

	
	SockAddrPlatform.sin_port = htons(DEFAULT_TPM_PLATFORM_PORT);
	SockAddrPlatform.sin_family = AF_INET;
	SockAddrPlatform.sin_addr.s_addr = *((unsigned long*)host->h_addr); 

	if(connect(SocketPlatform,(SOCKADDR*)(&SockAddrPlatform),sizeof(SockAddrPlatform))!=0)
	{
		printf("Failed to establish connection with server\n");
		//WSACleanup();
		//system("PAUSE");
		//return -1;
	}


	//second socket
	SocketTPM = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP);
	if(SocketTPM==INVALID_SOCKET)
	{
		printf("Winsock error - Socket creation Failed!\r\n");
		WSACleanup();
		//system("PAUSE");
		return -1;
	}
	
	host=gethostbyname("localhost"); 
	if((host=gethostbyname("localhost"))==NULL)
	{
		printf("Failed to resolve hostname.\n");
		WSACleanup();
		//system("PAUSE");
		return -1;
	}

	
	SockAddrTPM.sin_port=htons(DEFAULT_TPM_COMMAND_PORT);
	SockAddrTPM.sin_family=AF_INET;
	SockAddrTPM.sin_addr.s_addr=*((unsigned long*)host->h_addr); 

	if(connect(SocketTPM,(SOCKADDR*)(&SockAddrTPM),sizeof(SockAddrTPM))!=0)
	{
		printf("Failed to establish connection with server\n");
		WSACleanup();
		//system("PAUSE");
		return -1;
	}

	return Status;
}



UINT32 TieSocketUnConfigure()
{
	UINT32 Status = 0;

	shutdown(SocketPlatform, SD_SEND); 
	closesocket(SocketPlatform); 

	shutdown(SocketTPM, SD_SEND); 
	closesocket(SocketTPM); 
	WSACleanup(); 

	return Status;
}

DWORD TieSendRecvPlatformCommand(char command)
{
	int iResult = 0;            // used to return function results
    char sendbuf[] = { 0x0,0x0,0x0,0x0 };
    char recvbuf[] = { 0x0, 0x0, 0x0, 0x0 };

    sendbuf[3] = command;
    
    // Send the command
    iResult = send( SocketPlatform, sendbuf, 4, 0 );
    
    if (iResult == SOCKET_ERROR) {
        wprintf(L"send failed with error: %d\n", WSAGetLastError());
        closesocket(SocketPlatform);
        WSACleanup();
        return 1;
    }
    else // if ( cmd != TPM_SIGNAL_POWER_OFF )
    {
        // Read result
        iResult = recv( SocketPlatform, recvbuf, 4, 0);
        if (iResult == SOCKET_ERROR) {
            wprintf(L"recv failed with error: %d\n", WSAGetLastError());
            closesocket(SocketPlatform);
            WSACleanup();
            return 1;
        }
        if( recvbuf[0] != 0 || recvbuf[1] != 0 || recvbuf[2] != 0 || recvbuf[3] != 0 )
        {
            wprintf( L"PlatformCommand failed with error: %d\n", recvbuf[3] );
            closesocket(SocketPlatform);
            WSACleanup();
            return 1;
        }
    }
    return 0;
}


UINT32 TieSendRecvTPMCommand(IN const char *sendBuffer, UINT32 numBytesSend, OUT char *responseBuffer, UINT32 *numBytesReceived)
{
	UINT32 Status = 0;
	int nDataLength = 0;
	UINT32 trash;
	char responseSize[4] = {0};
	int i = 0;
	//int tcpResponseSize = 0;

	union {
		unsigned int int_data;
		unsigned char char_buff[4];
	} tmp;

	//send the command bytes
	nDataLength = send(SocketTPM, sendBuffer, numBytesSend, 0);

	//receive the response size
	nDataLength = recv(SocketTPM, (char*) responseSize, 4, 0);

	
	// convert the character buffer into integer
	for (i = 0; i < 4; i++)
		tmp.char_buff[i] = responseSize[i]; 

	*numBytesReceived = ntohl(tmp.int_data);	

	//read again, response size number of bytes
	nDataLength = recv(SocketTPM, responseBuffer, *numBytesReceived, 0);

	nDataLength = recv(SocketTPM, (char *)&trash, 4, 0);

	return Status;
}

/*
Description: Write a TPM command to TPM and Execute commmand and read the response from TPM.
Remark: This assume that caller has converted all the fields in TPM Command structure to BigEndian.
*/
/*
UINT8 ExecuteTPMCmd(UINT8 *pu8InBuff, UINT32 u32InBuffLen, UINT8 *pu8OutBuff, UINT32 u32OutBuffLen)
{
	UINT8 u8TPMDriverCode = TCG_OK;
	TPM *pTPM = NULL;
	UINT8 u8CmdRetryCntr = 0;
	const TPM_Header_In * pTPMCmdHdrIn = NULL;
	//UINT16 u16TempTPM_STS = 0;
	
	if(u32OutBuffLen < sizeof(TPM_Header_Out)){
		errColor;
		DEBUG_LOG((L"ERROR : ExecuteTPMCmd(), Output buffer too short\n"));
		norColor;
		u8TPMDriverCode = TCG_OUTPUT_BUFFER_TOO_SHORT;
	}

	pTPMCmdHdrIn = (TPM_Header_In *)pu8InBuff; //Be carefull fields in the Input Buffer are already converted to the Big Endian
	if(ChangeEndiannessDWord(pTPMCmdHdrIn->paramSize) != u32InBuffLen){
		errColor;
		DEBUG_LOG((L"ERROR : ExecuteTPMCmd(), Invalid input parameter\n"));
		norColor;
		u8TPMDriverCode = TCG_INVALID_INPUT_PARA;
	}
	
	if(TCG_OK != u8TPMDriverCode){
		return u8TPMDriverCode;
	}

	pTPM = (TPM *) TPM_BASE_0;

	//Start sending command to TPM
	for(u8CmdRetryCntr = 0; u8CmdRetryCntr < TPM_CMD_RETRY_COUNT; u8CmdRetryCntr++){
		u8TPMDriverCode = TCG_INVALID_RESPONSE;

		//Clear FIFO, i.e. Try to make the TPM ready to accept new command, software shold not start sending command
		//	untill TPM is in the ready state to accept new command
		//u16TempTPM_STS = pTPM->STS.Raw;
		//u16TempTPM_STS = (u16TempTPM_STS | (0x1 << 6)); //Set TPM_STS.commandReady Bit[6]
		///pTPM->STS.Raw = u16TempTPM_STS;
		pTPM->STS.Raw = (0x1 << 6);

		//Wait and let the TPM ready to accept new command
		if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, commandReadyStatusCheck, NULL)){
			//TPM is not ready to accept new command 
			//Try again to make the TPM ready to accept new command 
			//u16TempTPM_STS = pTPM->STS.Raw;
			//u16TempTPM_STS = (u16TempTPM_STS | (0x1 << 6)); //Set TPM_STS.commandReady Bit[6]
			//pTPM->STS.Raw = u16TempTPM_STS;
			pTPM->STS.Raw = (0x1 << 6);
			
			//Wait and let the TPM ready to accept new command
			if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, commandReadyStatusCheck, NULL)){
				//Still TPM is not ready to accept new command 
				u8TPMDriverCode = TCG_RESPONSE_TIMEOUT;
				break; //Cannot execute command, TPM is not ready to accept new command
			}
		}

		//Send command bytes to TPM
		u8TPMDriverCode = SendCmdBytesToTPM(pu8InBuff);

		if(TCG_CMD_OVER_UNDER_WRITE == u8TPMDriverCode){
			//Need to re-issue the command
			continue;
		}
		
		break;
	}

	if(TCG_OK != u8TPMDriverCode){
		DEBUG_LOG((L"ERROR : ExecuteTPMCmd(), Error in sending command\n"));
		return u8TPMDriverCode;
	}
	
	//Now all the command bytes have been sent, Start command execution
	//u16TempTPM_STS = pTPM->STS.Raw;
	//u16TempTPM_STS = (u16TempTPM_STS | (0x1 << 5)); //Set TPM_STS.tpmGo to start command execution
	//pTPM->STS.Raw = u16TempTPM_STS;
	pTPM->STS.Raw = (0x1 << 5);

	//Prepare to read command response
	for(u8CmdRetryCntr = 0; u8CmdRetryCntr < TPM_CMD_RETRY_COUNT; u8CmdRetryCntr++){
		u8TPMDriverCode = TCG_INVALID_RESPONSE;

		if(u8CmdRetryCntr > 0){
			//Retrying to retrieve the response, so Set TPM_STS.responseRetry
			//u16TempTPM_STS = pTPM->STS.Raw;
			//u16TempTPM_STS = (u16TempTPM_STS | (0x1 << 1)); //Set TPM_STS.responseRetry bit[1], to force TPM to re-send the response
			//pTPM->STS.Raw = u16TempTPM_STS;
			pTPM->STS.Raw = (0x1 << 1);
		}
		
		//Start reading command response, start with response tag and paramSize
		u8TPMDriverCode = ReadTPMResponseBytes(pu8OutBuff);

		if(TCG_CMD_OVER_UNDER_WRITE == u8TPMDriverCode){
			continue;
		}
		break;
	}

	if(TCG_OK != u8TPMDriverCode){
		errColor;
		DEBUG_LOG((L"ERROR : ExecuteTPMCmd(), error in reading response bytes\n"));
		norColor;
		return u8TPMDriverCode;
	}
	//Clear FIFO, i.e. make the TPM ready to accept new command after done with our command
	//u16TempTPM_STS = pTPM->STS.Raw;
	//u16TempTPM_STS = (u16TempTPM_STS | (0x1 << 6)); //Set TPM_STS.commandReady Bit[6]
	//pTPM->STS.Raw = u16TempTPM_STS;
		pTPM->STS.Raw = (0x1 << 6);
	
	return u8TPMDriverCode;
}
*/

/*
Return: 
	TCG_OK => Successfully sent the command to TPM Interface
	TCG_RESPONSE_TIMEOUT => TimeOut
	TCG_CMD_OVER_UNDER_WRITE => TPM expect no bytes even we are left with one byte to send,
								or expect more even after sending all cmd bytes
*/
/*
UINT8 SendCmdBytesToTPM(UINT8 *pCmdBytes)
{
	UINT8 u8Status = TCG_OK; 
	TPM *pTPM = (TPM *) TPM_BASE_0;
	TPM_Header_In *pTPMHdrIn = (TPM_Header_In *)pCmdBytes;
	UINT32 u32TPMCmdparamSize = ChangeEndiannessDWord(pTPMHdrIn->paramSize); //Back to little endian
	UINT16 u8BurstCount = 0;
	UINT32 u32ByteCntr = 0;

	UINT32 *pTPMStatus = TPM_BASE_0 + 0x18;
	//Print(L"pTPMStatus: 0x%04x\n", *pTPMStatus);
	u8BurstCount = (*pTPMStatus >> 8) & 0x0000FFFF;
	
	//Print(L"u8BurstCount: 0x%04x\n", u8BurstCount);
	if( ( TPM_STATUS_SUCCESS == WaitAndStatusCheck(1000, stsBurstCountValidStatusCheck, &u8BurstCount) ) || ( u8BurstCount > 0 ) ){
		//Print(L"Initial TPM_STS.burstCount: 0x%X\n",u8BurstCount);//BurstCount should be non zero

		//Send the first byte of TPM Command, i.e. write the 1st command byte to TPM_DATA_FIFO
		u32ByteCntr = 0;
		pTPM->DATA_FIFO = pCmdBytes[u32ByteCntr];
		ASMIODelay(); //delay
		//Print(L"Command byte Written[%d]:0x%X\n",u32ByteCntr,pCmdBytes[u32ByteCntr]);
		u8BurstCount--; //Decrement the burst count.

		//Send the remaining bytes except the last one.
		for(u32ByteCntr = 1; u32ByteCntr < (u32TPMCmdparamSize - 1); u32ByteCntr++){
			if(0 == u8BurstCount){
				if(TPM_STATUS_SUCCESS == WaitAndStatusCheck(1000, stsValidAndExpectStatusCheck, NULL)){
					//TPM is expecting more command bytes
					//u8BurstCount = pTPM->STS.Bytes.HIGH; //Read the burst count
					u8BurstCount = (*pTPMStatus >> 8) & 0x0000FFFF;
					//Print(L"TPM is expecting more command bytes, TPM_STS.burstCount is 0x%X\n",u8BurstCount );
					if(0 == u8BurstCount){
						//TPM may take some time to update burstCount so wait and keep polling
						if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, stsBurstCountValidStatusCheck, &u8BurstCount)){
							errColor;
							DEBUG_LOG((L"ERROR: TPM is expecting more command bytes, STS.burstCount is 0x%X (should be NON-ZERO)\n",u8BurstCount ));
							norColor;
							u8Status = TCG_RESPONSE_TIMEOUT;  //TimeOut
							break;
						}
					}
				}
				else{
					errColor;
					//Print(L"ERROR : SendCmdBytesToTPM(), stsValidAndExpectStatusCheck fails, but we are yet left with command bytes to be sent\n");
					norColor;
					u8Status = TCG_RESPONSE_TIMEOUT;  //TimeOut
					break;
				}
			}

			if(u8BurstCount){
				pTPM->DATA_FIFO = pCmdBytes[u32ByteCntr];
				ASMIODelay(); //delay
				//Print(L"Command byte Written[%d]:0x%X\n",u32ByteCntr,pCmdBytes[u32ByteCntr]);
				u8BurstCount--; //Decrement the burst count.
			}
			else{
				errColor;
				//Print(L"ERROR : SendCmdBytesToTPM(), Execution Control reached here because of some Error\n");
				norColor;
				break;
			}
		} //End for loop

		//Make sure that only one command byte is left to be sent
		if((u32TPMCmdparamSize - 1) != u32ByteCntr){
			errColor;
			//Print(L"ERROR : SendCmdBytesToTPM(), Execution Control reached here because of some Error\n");
			norColor;
			u8Status = TCG_GENERAL_ERROR;
			return u8Status;
		}

		//Send last byte of the TPM command.
		//Check if stsValid is set
		if(TPM_STATUS_SUCCESS == WaitAndStatusCheck(1000, stsValidStatusCheck, NULL)){
			//Print(L"TPM_STS.stsValid is set, after sending all but last command bytes\n");
			if(pTPM->STS.Bytes.LOW & (0x1 << 3)){ 
				//TPM_STS.Expect bit[3] is set as expected
				if(0 == u8BurstCount){
					//u8BurstCount = pTPM->STS.Bytes.HIGH;
					u8BurstCount = (*pTPMStatus >> 8) & 0x0000FFFF;
					if(0 == u8BurstCount){
						//Wait and keep polling the burstCount
						if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, stsBurstCountValidStatusCheck, &u8BurstCount)){
							errColor;
							//Print(L"ERROR : SendCmdBytesToTPM(), stsBurstCountValidStatusCheck fails, TPM_STS.burstCount is 0x%X\n",u8BurstCount );
							norColor;
							u8Status = TCG_RESPONSE_TIMEOUT;  //TimeOut
						}
					}
				}

				if(u8BurstCount){
					pTPM->DATA_FIFO = pCmdBytes[u32ByteCntr];
					ASMIODelay(); //delay
					//Print(L"Last Command byte Written[%d]: 0x%X\n",u32ByteCntr,pCmdBytes[u32ByteCntr]);
					u8BurstCount--; //Decrement the burst count.
				}
				else{
					//Print(L"ERROR : SendCmdBytesToTPM(), Execution Control reached here because of some Error\n");
					u8Status = TCG_GENERAL_ERROR;
				}

				if(TPM_STATUS_SUCCESS == WaitAndStatusCheck(1000, stsValidStatusCheck, NULL)){
					if(pTPM->STS.Bytes.LOW & (0x1 << 3)){
						//TPM_STS.Expect bit[3] is NOT Clear
						errColor;
						//Print(L"ERROR : SendCmdBytesToTPM(), Over/Under Run, last byte is already sent, but TPM Except more,\n TPM_STS.Expect bit[3] is Set\n");
						norColor;
						u8Status = TCG_CMD_OVER_UNDER_WRITE; //Over/Under Run
					}
				}
				else{
					errColor;
					//Print(L"ERROR : SendCmdBytesToTPM(), TPM Status register is not valid after last command byte write\n");
					norColor;
					u8Status = TCG_RESPONSE_TIMEOUT;  //TimeOut
				}
			}
			else{
				//TPM_STS.Expect bit[3] is Clear
				errColor;
				//Print(L"ERROR : SendCmdBytesToTPM(), Over/Under Run, last byte is still to be sent, but TPM doesn't Except it,\n TPM_STS.Expect bit[3] is Clear\n");
				norColor;
				u8Status = TCG_CMD_OVER_UNDER_WRITE; //Over/Under Run
			}
		}
		else{
			errColor;
			//Print(L"ERROR : SendCmdBytesToTPM(), TPM Status register is not valid\n");
			norColor;
			u8Status = TCG_RESPONSE_TIMEOUT;  //TimeOut
		}
	}
	else{
		errColor;
		//Print(L"ERROR : SendCmdBytesToTPM(), Initial TPM_STS.burstCount: 0x%X\n",u8BurstCount);
		norColor;
		u8Status = TCG_RESPONSE_TIMEOUT;  //TimeOut
	}

	return u8Status;

}
*/
/*Description: Reads the response from TPM*/
/*
UINT8 ReadTPMResponseBytes(UINT8 *pu8OutBuff)
{
	UINT8 u8RespStatus = TCG_OK;
	UINT8 u8NumBytesToRead = 6; //sizeof(TPM_Header_Out.tag) + sizeof(TPM_Header_Out.paramSize);
	UINT16 u8BurstCount = 0;
	UINT32 u32ByteCntr = 0;
	UINT32 i = 0;
	TPM *pTPM = (TPM *) TPM_BASE_0;
	const TPM_Header_Out * pTPMCmdHdrOut = NULL;
	UINT32 u32OutputParamSize = 0;
	UINT32 *pTPMStatus = TPM_BASE_0 + 0x18;
	
	//First read the response tag and paramSize
	for(u32ByteCntr = 0; u32ByteCntr < u8NumBytesToRead; u32ByteCntr++){
		if(0 == u8BurstCount){
			if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1200, stsValidAnddataAvailStatusCheck, NULL)){
				u8RespStatus = TCG_RESPONSE_TIMEOUT; //TimeOut
				break;
			}
			else{
				//Read maximum burst count
				//u8BurstCount = pTPM->STS.Bytes.HIGH;
				u8BurstCount = (*pTPMStatus >> 8) & 0x0000FFFF;
				if(0 == u8BurstCount){
					if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, stsBurstCountValidStatusCheck, &u8BurstCount)){
						errColor;
						//Print(L"ERROR : ReadTPMResponseBytes(), stsBurstCountValidStatusCheck fails for response read, TPM_STS.burstCount is 0x%X\n", u8BurstCount );
						//Print(L"ERROR : First read maximum burst count\n" );
						norColor;
						u8RespStatus = TCG_RESPONSE_TIMEOUT;  //TimeOut
						break;
					}
				}
			}
		}

		if(u8BurstCount){
			pu8OutBuff[u32ByteCntr] = pTPM->DATA_FIFO;
			ASMIODelay(); //delay
			//Print(L"Response byte read[%d]: 0x%X\n",u32ByteCntr,pu8OutBuff[u32ByteCntr]);
			u8BurstCount--;
		}
		else{
			errColor;
			//Print(L"ERROR : ReadTPMResponseBytes(), Execution Control reached here because of some Error\n");
			norColor;
			u8RespStatus = TCG_GENERAL_ERROR;
		}
	}

	if(TCG_OK != u8RespStatus){
		errColor;
		//Print(L"ERROR : ReadTPMResponseBytes(), Reading response tag and paramSize failed, Status: 0x%X\n",u8RespStatus);
		norColor;
		return u8RespStatus;
	}
	
	//We have got the output tag and paramSize
	pTPMCmdHdrOut = (TPM_Header_Out *)pu8OutBuff;
	u32OutputParamSize = ChangeEndiannessDWord(pTPMCmdHdrOut->paramSize); //to little-endian
	//Print(L"u32OutputParamSize %d\n",u32OutputParamSize );
	//Now read all bytes but one (last byte)
	
	
	//for(; u32ByteCntr < u32OutputParamSize; u32ByteCntr++){
	//	Print(L"u32ByteCntr: %d\n", u32ByteCntr);
	//	Print(L"u8BurstCount: %d\n", u8BurstCount);
	//	for ( i = 6; i < u8BurstCount; i++ ) {
	//		pu8OutBuff[u32ByteCntr] = pTPM->DATA_FIFO;
	//		u32ByteCntr++;
	//		ASMIODelay(); //delay
	//	}
	//	u8BurstCount = pTPM->STS.Bytes.HIGH;
	//}
	//for(; u32ByteCntr < u32OutputParamSize; u32ByteCntr++){
	//	Print(L"u32ByteCntr: %d\n", u32ByteCntr);
	//	Print(L"u8BurstCount: %d\n", u8BurstCount);
	//	for ( i = 0; i < u8BurstCount; i++ ) {
	//		pu8OutBuff[u32ByteCntr] = pTPM->DATA_FIFO;
	//		u32ByteCntr++;
	//		ASMIODelay(); //delay
	//	}
	//	u8BurstCount = pTPM->STS.Bytes.HIGH;
	//}
	
	for(; u32ByteCntr < (u32OutputParamSize -1); u32ByteCntr++){
		if(0 == u8BurstCount){
			if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, stsValidAnddataAvailStatusCheck, NULL)){
				u8RespStatus = TCG_RESPONSE_TIMEOUT; //TimeOut
				break;
			} else {
				//Read maximum burst count
				//u8BurstCount = pTPM->STS.Bytes.HIGH;
				u8BurstCount = (*pTPMStatus >> 8) & 0x0000FFFF;
				if(0 == u8BurstCount){
					if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, stsBurstCountValidStatusCheck, &u8BurstCount)){

						//Print(L"u8BurstCount: 0x%04x\n", u8BurstCount);
						errColor;
						//Print(L"ERROR : ReadTPMResponseBytes(), stsBurstCountValidStatusCheck fails for response read, TPM_STS.burstCount is 0x%X\n",u8BurstCount );
						//Print(L"ERROR : Second read maximum burst count\n" );
						norColor;
						u8RespStatus = TCG_RESPONSE_TIMEOUT;  //TimeOut
						break;
					}
				}
			}
		}
		
		if(u8BurstCount){
			pu8OutBuff[u32ByteCntr] = pTPM->DATA_FIFO;
			ASMIODelay(); //delay
			//Print(L"TPM_STS.burstCount = %d ", u8BurstCount );
			//Print(L"Response byte read[%d]: 0x%X\n",u32ByteCntr,pu8OutBuff[u32ByteCntr]);
			u8BurstCount--;
		}
		else{
			errColor;
			//Print(L"ERROR : ReadTPMResponseBytes(), Execution Control reached here because of some Error\n");
			norColor;
			u8RespStatus = TCG_GENERAL_ERROR;
		}
		
	}
	
	if(TCG_OK != u8RespStatus){
		errColor;
		//Print(L"ERROR : ReadTPMResponseBytes(), Reading all response bytes but one (last byte) failed, Status: 0x%X\n",u8RespStatus);
		norColor;
		return u8RespStatus;
	}

	//Read last response byte
	
	if(TPM_STATUS_SUCCESS == WaitAndStatusCheck(1000, stsValidStatusCheck, NULL)){
		//Check TPM_STS.dataAvail bit[4], it must be set because one more response byte is expected
		if(pTPM->STS.Raw & (0x1 << 4)){
			//TPM_STS.dataAvail is set, i.e. last byte is available read it
			if(0 == u8BurstCount){
				//u8BurstCount = pTPM->STS.Bytes.HIGH;
				u8BurstCount = (*pTPMStatus >> 8) & 0x0000FFFF;
				if(0 == u8BurstCount){
					if(TPM_STATUS_FAILURE == WaitAndStatusCheck(1000, stsBurstCountValidStatusCheck, &u8BurstCount)){
						errColor;
						//Print(L"ERROR : ReadTPMResponseBytes(), stsBurstCountValidStatusCheck fails for reading last response byte, TPM_STS.burstCount is 0x%X\n",u8BurstCount );
						norColor;
						u8RespStatus = TCG_RESPONSE_TIMEOUT;  //TimeOut
					}
				}
			}

			if(u8BurstCount){
				pu8OutBuff[u32ByteCntr] = pTPM->DATA_FIFO;
				ASMIODelay(); //delay
				//Print(L"Last Response byte read[%d]: 0x%X\n",u32ByteCntr,pu8OutBuff[u32ByteCntr]);
				u8BurstCount--;
			}
			else{
				errColor;
				//Print(L"ERROR : ReadTPMResponseBytes(), Execution Control reached here because of some Error\n");
				norColor;
				u8RespStatus = TCG_GENERAL_ERROR;
			}

			//Wait for stsValid bit set - this indicates validity of dataAvail bit
			if(TPM_STATUS_SUCCESS == WaitAndStatusCheck(1000, stsValidStatusCheck, NULL)){
				if(pTPM->STS.Raw & (0x1 << 4)){
					//TPM still showing response data available, but we have read all the response bytes
					errColor;
					//Print(L"ERROR : ReadTPMResponseBytes(), TPM still showing response data available, but we have read all the response bytes\n");
					norColor;
					u8RespStatus = TCG_CMD_OVER_UNDER_WRITE;//Over/Under Run
				}
			}
			else{
				u8RespStatus = TCG_RESPONSE_TIMEOUT; //TimeOut
			}
		}
		else{
			u8RespStatus = TCG_CMD_OVER_UNDER_WRITE;//Over/Under Run
		}
	}	else{
		u8RespStatus = TCG_RESPONSE_TIMEOUT; //TimeOut
	}
	
	return u8RespStatus;
}
*/
/************************************************/
/*Converts a WORD to Big Endian WORD*/

UINT16 ChangeEndiannessWord(UINT16 u16Val)
{
	UINT16 u16ValReturn = 0;
	UINT8 u8Temp = 0;
	UINT8 u8ByteIndex = 0;

	for(u8ByteIndex = 0; u8ByteIndex < sizeof(UINT16); u8ByteIndex++){
		u8Temp = ((u16Val >> (u8ByteIndex * 8)) & 0xFF);
		u16ValReturn = ((u16ValReturn <<  8) | u8Temp);
	}
	return u16ValReturn;
}

/************************************************/
/*Converts a DWORD to Big Endian DWORD*/

UINT32 ChangeEndiannessDWord(UINT32 u32Val)
{
	UINT32 u32ValReturn = 0;
	UINT8 u8Temp = 0;
	UINT8 u8ByteIndex = 0;

	for(u8ByteIndex = 0; u8ByteIndex < sizeof(UINT32); u8ByteIndex++){
		u8Temp = ((u32Val >> (u8ByteIndex * 8)) & 0xFF);
		u32ValReturn = ((u32ValReturn << 8) | u8Temp);
	}
	return u32ValReturn;
}


int PlatformCommand( char cmd )
{
    int iResult = 0;            // used to return function results
    char sendbuf[] = { 0x0,0x0,0x0,0x0 };
    char recvbuf[] = { 0x0, 0x0, 0x0, 0x0 };

    sendbuf[3] = cmd;
    
    // Send the command
    iResult = send( SocketPlatform, sendbuf, 4, 0 );
    
    if (iResult == SOCKET_ERROR) {
        wprintf(L"send failed with error: %d\n", WSAGetLastError());
        closesocket(SocketPlatform);
        WSACleanup();
        return 1;
    }
    else // if ( cmd != TPM_SIGNAL_POWER_OFF )
    {
        // Read result
        iResult = recv( SocketPlatform, recvbuf, 4, 0);
        if (iResult == SOCKET_ERROR) {
            wprintf(L"recv failed with error: %d\n", WSAGetLastError());
            closesocket(SocketPlatform);
            WSACleanup();
            return 1;
        }
        if( recvbuf[0] != 0 || recvbuf[1] != 0 || recvbuf[2] != 0 || recvbuf[3] != 0 )
        {
            wprintf( L"PlatformCommand failed with error: %d\n", recvbuf[3] );
            closesocket(SocketPlatform);
            WSACleanup();
            return 1;
        }
    }
    return 0;
}

/************************************************/

/* check TPM_ACCESS_0.tpmRegValidSts bit[7]
Return: TPM_STATUS_SUCCESS => TPM_ACCESS_0.tpmRegValidSts bit[7] is set, All the bits in ACCESS register are valid
		TPM_STATUS_FAILURE => bit tpmRegValidSts is not set, TPM is broken, don't use it. 
		
*/
/*
UINT8 tpmRegValidStsStatusCheck(void *pBuffer)
{
	TPM *pTPM = (TPM *) TPM_BASE_0;
	return (pTPM->ACCESS & (0x1 << 7)) ? TPM_STATUS_SUCCESS : TPM_STATUS_FAILURE;
}
*/
/*check TPM_ACCESS_0.activeLocality bit[5], 
Return:	TPM_STATUS_SUCCESS => This locality is active.
		TPM_STATUS_FAILURE => This locality is not active.
*/
/*
UINT8 activeLocalityStatusCheck(void *pBuffer)
{
	TPM *pTPM = (TPM *) TPM_BASE_0;
	return (pTPM->ACCESS & (0x1 << 5)) ? TPM_STATUS_SUCCESS : TPM_STATUS_FAILURE;
}
*/

/*check TPM_STS.commandReady bit[6]
Return:	TPM_STATUS_SUCCESS => Ready to accept new command.
		TPM_STATUS_FAILURE => Not ready to accept new command.
*/
/*
UINT8 commandReadyStatusCheck(void *pBuffer)
{
	TPM *pTPM = (TPM *) TPM_BASE_0;
	return (pTPM->STS.Bytes.LOW & (0x1 << 6)) ? TPM_STATUS_SUCCESS : TPM_STATUS_FAILURE;
}
*/
/*collect burst count in provided buffer
Return:	TPM_STATUS_SUCCESS => Success, BurstCount is non zero.
		TPM_STATUS_FAILURE => Failure, BurstCount is zero.		
*/
/*
UINT8 stsBurstCountValidStatusCheck(void *pBuffer)
{
	TPM *pTPM = (TPM *) TPM_BASE_0;
	UINT32 *pTPMStatus = TPM_BASE_0 + 0x18;
	UINT8 *pBurstCount = (UINT8 *)pBuffer;
	UINT16 u8BurstCount = 0;
	UINT8 u8Status = TPM_STATUS_FAILURE; //Failure

	//u8BurstCount = pTPM->STS.Bytes.HIGH;
	u8BurstCount = (*pTPMStatus >> 8) & 0x0000FFFF;
	if(0 == u8BurstCount){
		u8Status = TPM_STATUS_FAILURE;//Failure
	}
	else{
		*pBurstCount = u8BurstCount;
		u8Status = TPM_STATUS_SUCCESS;//Success
	}

	return u8Status;
}
*/
/*Check TPM_STS.stsValid bit [7] and TPM_STS.expect bit [3]
  Return:	TPM_STATUS_SUCCESS => TPM_STS.stsValid bit [7] and TPM_STS.expect bit [3] both are set
			TPM_STATUS_FAILURE => Any of the TPM_STS.stsValid bit [7] and TPM_STS.expect bit [3] or both are not set
*/
/*
UINT8 stsValidAndExpectStatusCheck(void *pBuffer)
{
	TPM *pTPM = (TPM *) TPM_BASE_0;
	UINT8 u8Status = TPM_STATUS_FAILURE; //Failure
	if((pTPM->STS.Bytes.LOW & (0x1 << 7)) && (pTPM->STS.Bytes.LOW & (0x1 << 3))){
		//TPM_STS.stsValid bit [7] and TPM_STS.expect bit [3] both are set
		u8Status = TPM_STATUS_SUCCESS; //Success
	}

	return u8Status;
}
*/
/************************************************/
/*Return:	TPM_STATUS_SUCCESS => Success, TPM_STS.stsValid bit [7] is set
			TPM_STATUS_FAILURE => Failure,TPM_STS.stsValid bit [7] is clear
*/
/*
UINT8 stsValidStatusCheck(void *pBuffer)
{
	TPM *pTPM = (TPM *) TPM_BASE_0;
	return (pTPM->STS.Bytes.LOW & (0x1 << 7)) ? TPM_STATUS_SUCCESS : TPM_STATUS_FAILURE;
}
*/
/************************************************/
/*Check TPM_STS.stsValid bit [7] and TPM_STS.dataAvail bit [4]
  Return:	TPM_STATUS_SUCCESS => TPM_STS.stsValid bit [7] and TPM_STS.dataAvail bit [4] both are set
			TPM_STATUS_FAILURE => Any of the TPM_STS.stsValid bit [7] and TPM_STS.dataAvail bit [4] or both are not set
*/
/*
UINT8 stsValidAnddataAvailStatusCheck(void *pBuffer)
{
	TPM *pTPM = (TPM *) TPM_BASE_0;
	UINT8 u8Status = TPM_STATUS_FAILURE; //Failure
	if((pTPM->STS.Bytes.LOW & (0x1 << 7)) && (pTPM->STS.Bytes.LOW & (0x1 << 4))){
		//TPM_STS.stsValid bit [7] and TPM_STS.dataAvail bit [4] both are set
		u8Status = TPM_STATUS_SUCCESS; //Success
	}

	return u8Status;
}
*/

